### Submission 4

- To run the final demo scene just double click the `RTR-W2023.exe`.
- Press ALT + F4 to exit the application.
- Press space bar to restart the animation.
- See [config file section](#use-config-file-for-other-scene-selection) to set hyperparameters (e.g. other `GLTF` scenes, enabling music, reconstruction filters, etc).
- Beware that the directory structure follows a similar structure as below, if you are using the pre-compiled version of our tool:
  ```
    - ./root_directory
        - ./build
            - raytracer.spv
        - ./models
            - possible_final_scene
                - possible_final_scene_test_time.glb
                - *** scene related files ***
            - *** other directories scenes **
                - *** scene related files ***
        - ./textures
            - PNG or JPG files
            - README.md
        - README.md
        - RTR-W2023.exe
  ```
- If you are building from source files, see the [build section](#build).

### Config file

A config file allows to set hyperparameters to our application without the need of recompilation. Here as an example:

```json
{
  "width": 1920, // render resolution on the x axis
  "height": 1080, // render resolution on the y axis
  "samplesPerPixel": 1, // # of samples 
  "maxRayBounces": 3, // maximum amount of a ray bounce
  "sceneFilePath": "models/possible_final_scene/ possible_final_scene.glb", // GLTF path of the scene
  "filterType": "Gaussian", // reconstruction filter type
  "isFullScreen": true, // should application run in full screen?
  "isMusicEnabled": true, // should be music enabled?
  "musicFilePath": "models/possible_final_scene/khruangbin-binbin-secretTrack.wav" // path of the music file
}
```

#### Usage

RTR-W2023.exe [config-file-path]

Pass config file path as first parameter to the exe.

#### Example
```
./RTR-W2023.exe final_config.json
```

### Keybinds:
 - SPACE: Pause/Resume animation
 - R: Reset animation
 - If the loaded scene doesn't contain animation: the camera can be rotated with *LMB-PRESS + MOVE* and translated by *LSHIFT + LMB-PRESS + MOVE*.
Users can modify the focus distance using *LSHIFT + SCROLL* and the depth of field using *LCTRL + SCROLL*.

### Clone
If you have access to our repository you can clone by:

```git
git clone https://github.com/pkomon-tgm/rtr23-dance-of-the-wisps.git
```

If you're unfamiliar with git, see introduction material [here](https://git-scm.com/book/en/v2/Git-Basics-Getting-a-Git-Repository).


### Build
Simply use CMake commands or CMake GUI to build.

You can download CMake [here](https://cmake.org/download/).

An introduction to CMake can be found [here](https://cmake.org/getting-started/).


If you use *Visual Studio Code* we recommend using the extension *CMake Tools by Microsoft*.

#### Simple steps using Visual Studio Code and CMake Extension
1. Open the root directory in Visual Studio Code
2. Click the CMake extension tab
3. If no compiler is selected, on the configure dropdown menu click *Configure* (paper symbol, or pen symbol) and select your compiler.
4. (Optional) Set a variant (e.g. Debug)
5. Select *Configure*.
6. Make sure Configuration steps ends successfully. See also [regarding vulkan](#regarding-vulkan) section.
7. Click *Build* on the build dropdown menu.

#### Run in Visual Studio Code
Example `launch.json` file can be find `.vscode` directory of this repository. An example:

```json
{
    "version": "0.2.0",
    "configurations": [
        {
            "name": "Release Launch",
            "type": "cppvsdbg",
            "request": "launch",
            "program": "${workspaceFolder}/build/Release/RTR-W2023.exe",
            "args": ["final_config.json"],
            "stopAtEntry": false,
            "cwd": "${workspaceFolder}",
            "environment": [],
            "console": "externalTerminal"
        },
    ]
  }
  
```

#### Simple steps using CMake GUI and Visual Studio
1. Open CMake GUI
2. Click *Browse Source...*.
3. Select the root directory where this document can be found.
4. (Optional) Click *Browse Build...* to select a build location.
5. Click *Configure*
   1. Select a generator. Usually a Visual Studio version that you have (e.g. Visual Studio 17 2022).
   2. (Optional) *x64* is used per default. We do not expect other generators to work.
   3. (Optional) *Use default native compilers* is selected per default. We do not tested other options.
   4. Click *Finish*
6. Make sure Configuration steps ends successfully. See also [regarding vulkan](#regarding-vulkan) section.
7. Click *Generate*
8. Click `*.sln` file and follow Visual Studio Steps for a build.




### Regarding Vulkan
Beware that CMake attempts to find Vulkan by itself (see CMakeLists.txt at root). 
If not found, you have to enter the path of Vulkan manually.
You can download Vulkan SDK [here](https://vulkan.lunarg.com/sdk/home#windows). An example where the `AUTO_LOCATE_VULKAN` is set to `OFF`:

```
# Finding Vulkan starts
# Following CMake lines for finding Vulkan are taken from: https://github.com/PacktPublishing/Learning-Vulkan/blob/master/Chapter%2003/HandShake/CMakeLists.txt
# AUTO_LOCATE_VULKAN - accepted value ON or OFF
# ON  - Use CMake to auto locate the Vulkan SDK.
# OFF - Vulkan SDK path can be specified manually. This is helpful to test the build on various Vulkan version.
option(AUTO_LOCATE_VULKAN "AUTO_LOCATE_VULKAN" OFF)

if(AUTO_LOCATE_VULKAN)
	// CMake attempts to find Vulkan on its own (good luck!)
else()
  // Manually find Vulkan installation
	message(STATUS "Attempting to locate Vulkan SDK using manual path......")
	set(VULKAN_SDK "C:/VulkanSDK") // Enter Vulkan Path
	set(VULKAN_VERSION "1.3.268.0") // Enter Vulkan Version
	set(VULKAN_PATH "${VULKAN_SDK}/${VULKAN_VERSION}")
	message(STATUS "Using manual specified path: ${VULKAN_PATH}")
  ...
endif()
```



### Tips
- Currently only Windows supported.
- Beware the path of shader files are obtained dynamically using ```std::filepath::current_path(fileName)```. If necessary, please modify it accordingly, and then build it. See also ```Engine::make_pipeline()```. This must be improved in the future.
- Beware that shader files needs to be compiled before each build (_assuming there has been a change in the shader files_). CMake tries to automate this process using `GLSLANG_VALIDATOR` (see also `CMakeLists.txt` at the project root). However, if `GLSLANG_VALIDATOR` isn't found by CMake, you have to compile shader file(s) manually. For that please run ```./shader_compiler.bat``` in the __projectRoot/src/shaders__ folder. Make sure that the compilation ends with no errors.
- Beware the Vulkan path entered in __src/shaders/shader_compiler.bat__. Modify it accordingly.
- Beware that compiled shader file will be located at __projectRoot/build__ and expected to be read from that location. If this is not the case, please modify shader file acquisition in `Engine::makePipeline()` accordingly.
- For devs: Careful with the use of code formatter. The order of included files matter.
- Beware that validation layers are "hardcodedly" on. In the future, this must be configurable by the user.
- Beware that all loaded meshes (i.e. triangles) must have corresponding normals per each vertex.
- `FILTER_TIME_OFFSET` is currently set to 0.0, meaning reconstruction filter will be always applied to the rendered image. However, for the initial rendered frames--including when the camera is updated--beware that there might be some noticable visual artifacts. Increasing this value means that the reconstruction filter will be not applied for the defined amount of time elapsed. See also the function `evalReconstructionFilter()` and the constant defined in the compute shader.
- To improve performance, our approach mirrors the concept of image upscaling. Specifically, users can adjust the `UPSCALE_FACTOR` in `raytracer.comp` to set the desired upscaling level for the rendered image. The default value is set to `1` (i.e., no image upscaling).
  - *Details*. Rather than rendering the image in a lower resolution and then (up)scaling it with the defined `UPSCALE_FACTOR`—which would have resulted in a complex refactoring of the underlying window and image creation process—during rendering we skip every `UPSCALE_FACTOR` of pixel which we would've *ray traced*. Finally, every pixel we **ray traced** is stored into the n-neighbours of the original pixel, where n is the `UPSCALE_FACTOR`. The implementation can be found in `upscaleAndStorePixels()`, `raytracer.comp`.
- We accumulate previous renders to reduce the noise on still (scene) renders. By still renders we refer to a scene where neither the camera nor the objects moves. In case of any camera or object movement, we reset the accumulation, therefore it is expected to observe noiser images upon dynamic scenes.
  - *Details*. We use `NUMBER_RENDERS_BEFORE` constant to start accumulate previous renders (default `4`). If the value of the `DynamicSceneData::numStillRenders` exceeds this constant, we start to accumulate the previous renders. The implementation details can be found in `void storePixel(const ivec2, vec3)`.
  - Beware that in still scenes we limit the maximum amount renders to `MAX_SPP` (default `1024`). Hence, if the sum of accumulated samples per pixel count (`sceneData.numStillRenders * sceneData.spp * sceneData.spp`) exceeds this constant, we skip renders. The implementation can be found in `void main()`.

