#version 450 core
out vec4 FragColor;

in vec2 TexCoords;

uniform sampler2D scene;
uniform sampler2D bloomBlur;
uniform sampler2D dirtMaskTexture;

uniform float exposure;
uniform float bloomStrength = 0.25f;
uniform float dirtMaskIntensity = 1.75f;
void main()
{
    //lerp scene and bloom
    vec3 result = vec3(0.0);
    vec3 hdr = texture(scene, TexCoords).rgb;
    vec3 blm = texture(bloomBlur, TexCoords).rgb;
    vec3 drt = texture(dirtMaskTexture, vec2(TexCoords.x, 1.0f - TexCoords.y)).rgb * dirtMaskIntensity;
    result = mix(hdr, blm + blm*drt, vec3(bloomStrength));
    
	// tone mapping and gamma correction to 2.2
    result = vec3(1.0) - exp(-result * exposure);
    const float gamma = 2.2;
    //result = pow(result, vec3(1.0 / gamma));
	//result = result * (result * (result * 0.305306011 + 0.682171111) + 0.012522878);
	
	vec3 S1 = sqrt(result);
	vec3 S2 = sqrt(S1);
	vec3 S3 = sqrt(S2);
	result = 0.585122381 * S1 + 0.783140355 * S2 - 0.368262736 * S3;
    FragColor = vec4(result, 1.0);
}