#version 450 core

uniform sampler2D colorTexture;

out vec4 fragColor;
in vec2 texcoord;

void main() {
  vec2 texelSize = 1.0 / vec2(textureSize(colorTexture, 0));
    float result = 0.0;
	int size = 2;
    for (int x = -size; x < size; ++x) 
    {
        for (int y = -size; y < size; ++y) 
        {
            vec2 offset = vec2(float(x), float(y)) * texelSize;
            result += texture(colorTexture, texcoord + offset).r;
        }
    }
    fragColor = vec4(vec3(result / (4 * 4)), 1.0);
}