#version 450 core

layout (location = 6) uniform mat4 projMatrix;
layout (location = 7) uniform mat4 viewMatrix;

uniform sampler2D positionTexture;
uniform sampler2D normalTexture;

#define NUM_SAMPLES 64
#define NUM_NOISE   4

out vec4 FragColor;
in vec2 texcoord;

uniform vec3 samples[NUM_SAMPLES];
uniform vec3 noise[NUM_NOISE];
uniform float radius    = 25;
uniform float bias      = 0.125;
uniform float magnitude = 1.1;
uniform float contrast  = 1.1;

void main() {


  FragColor = vec4(1);

  vec4 position = texture(positionTexture, texcoord);
  //if (position.a <= 0) { return; }

  vec3 normal = normalize(texture(normalTexture, texcoord).xyz);

  int  noiseS = int(sqrt(NUM_NOISE));
  int  noiseX = int(gl_FragCoord.x - 0.5) % noiseS;
  int  noiseY = int(gl_FragCoord.y - 0.5) % noiseS;
  vec3 random = noise[noiseX + (noiseY * noiseS)];

  vec3 tangent  = normalize(random - normal * dot(random, normal));
  vec3 binormal = cross(normal, tangent);
  mat3 tbn      = mat3(tangent, binormal, normal);

  float occlusion = 0;

  for (int i = 0; i < NUM_SAMPLES; ++i) {
    vec3 samplePosition = tbn * samples[i];
         samplePosition = position.xyz + samplePosition * radius;

    vec4 offsetUV      = vec4(samplePosition, 1.0);
         offsetUV      = projMatrix * offsetUV;
         offsetUV.xyz /= offsetUV.w;
         offsetUV.xy   = offsetUV.xy * 0.5 + 0.5;
	
	float sampleDepth = texture(positionTexture, offsetUV.xy).z; 
	float rangeCheck = smoothstep(0.0, 1.0, radius / abs(position.z - sampleDepth));
	occlusion       += (sampleDepth >= samplePosition.z + bias ? 1.0 : 0.0) * rangeCheck;
  }

  occlusion /= NUM_SAMPLES;
  occlusion  = pow(occlusion, magnitude);
  occlusion  = contrast * (occlusion - 0.5) + 0.5;
  occlusion = 1.0 - occlusion;       	
  FragColor = vec4(vec3(occlusion), 1.0);
}