#version 430 core
layout (location = 0) in vec3 aPosition;
layout (location = 1) in vec3 aNormal;
layout (location = 2) in vec2 aTexcoord;
layout (location = 3) in vec3 aTangent;
layout (location = 4) in vec3 aBitangent;

layout (location = 5) uniform mat4 modelMatrix;
layout (location = 6) uniform mat4 projMatrix;
layout (location = 7) uniform mat4 viewMatrix;

out vec2 TexCoord;
out vec3 Normal;
out vec3 FragPos;

void main() 
{
	FragPos = vec3(modelMatrix * vec4(aPosition, 1.0));
    mat4 mvp = projMatrix * viewMatrix * modelMatrix;
    gl_Position = mvp * vec4(aPosition, 1.0);
	Normal = mat3(transpose(inverse(modelMatrix))) * aNormal;  
	TexCoord = aTexcoord;
}
