#version 430 core

layout (location = 1) uniform vec3 vertexColor;
layout (binding = 0) uniform sampler2D diffuseTexture;

out vec4 fragColor;


in vec2 TexCoord;
in vec3 Normal;
in vec3 FragPos;
uniform int drawNormal;

struct Material {
    vec3 ambient;
    vec3 diffuse;
    vec3 specular;
    float shininess;
	float roughness;
}; 
  
struct PointLight {
    vec3 lightPosition;
    float lightIntensity;

    float lightConstant;
    float lightLinear;
    float lightQuadratic;
	
    vec3 lightColor;
};

uniform sampler2D specularTexture;

vec3 CalcPointLight(PointLight light, vec3 normal, vec3 fragPos, vec3 viewDir);
vec3 CalcDirLight(PointLight light, vec3 normal, vec3 viewDir);
uniform vec3 viewPos;

uniform PointLight pointLight;

uniform Material material;

void main()
{
	vec4 texColor = texture(diffuseTexture, TexCoord);
	if(texColor.a < 1)
		discard;
	vec3 norm = normalize(Normal);
    vec3 viewDir = normalize(viewPos - FragPos);
    
    vec3 result = vec3(0.0);
	result += CalcPointLight(pointLight, norm, FragPos, viewDir);  
	result += CalcDirLight(pointLight, norm, viewDir);  
	
	//
	if(drawNormal == 1)
	{
		fragColor = vec4(Normal, 1.0); //texColor;	
	}
	else
	{
		vec3 I = normalize(FragPos - viewPos);
		vec3 R = reflect(I, normalize(Normal));
		fragColor = vec4(result, texColor.a );
		//float gamma = 2.2;
		//fragColor.rgb = fragColor.rgb;// pow(fragColor.rgb, vec3(1.0/gamma));
		if(fragColor.a < 1)
			discard;
		//fragColor.rg = TexCoord;
		//fragColor.b = 0;
	}
}

vec3 CalcDirLight(PointLight light, vec3 normal, vec3 viewDir)
{
   vec3 _lightDir = normalize(light.lightPosition - FragPos);

   vec3 lightDir = _lightDir;//normalize(-light.direction);

   float diff = max(dot(normal, lightDir), 0.0);
   vec3 reflectDir = reflect(-lightDir, normal);
   float spec = pow(max(dot(viewDir, reflectDir), 0.0), material.shininess);

   vec3 diffuseColor = texture(diffuseTexture, TexCoord).rgb;
   //vec3 diffuseColor = vec3(1);
   vec3 ambient = material.ambient *diffuseColor   * light.lightColor;
   vec3 diffuse = material.diffuse *diffuseColor   * light.lightColor * diff;
   vec3 specular = light.lightColor * spec;

   return (((ambient + diffuse) + specular) * 0.5);
}

vec3 CalcPointLight(PointLight light, vec3 normal, vec3 fragPos, vec3 viewDir)
{
   vec3 lightDir = normalize(light.lightPosition - fragPos);

    float diff = max(dot(normal, lightDir), 0.0);
    vec3 reflectDir = reflect(-lightDir, normal);
    float spec = pow(max(dot(viewDir, reflectDir), 0.0), material.shininess);

    float distance = length(fragPos - light.lightPosition);
    float attenuation = 1.0 / (light.lightConstant + light.lightLinear * distance + light.lightQuadratic * (distance * distance));
	float gamma = 2.2;
	vec3 diffuseColor = texture(diffuseTexture, TexCoord).rgb;
    //vec3 diffuseColor = vec3(1);
    vec3 ambient = material.ambient * diffuseColor * light.lightColor;
    vec3 diffuse = material.diffuse * diffuseColor * light.lightColor * diff;
    vec3 specular =material.specular * light.lightColor * spec;

    ambient *= attenuation;
    diffuse *= attenuation;
    specular *= attenuation;

    return (((ambient + diffuse+ specular)) * light.lightIntensity); //
}