#version 430 core

out vec4 FragColor;

in vec4 gl_FragCoord;
in vec2 TexCoords;
in vec2 vPos;

//input

uniform sampler2D inTex;

uniform float i_hardScan;
uniform float i_hardPix;
uniform float i_hardBloomScan;
uniform float i_bloomAmount;
uniform float i_warpX;
uniform float i_warpY;

uniform float i_maskDark;
uniform float i_maskLight;
uniform vec2 i_scale;
uniform vec2 i_resolution;


uniform float i_maskSize;
uniform float i_scanOffset;

uniform int i_maskType;

///=============================

vec2 getResuolution() {
	//if(i_useNos == 0) {
	//	return i_resolution;
	//}
	//else {
		return vec2(i_resolution.x / i_scale.x, i_resolution.y / i_scale.y);
	//}
}

vec3 fetch(vec2 pos,vec2 off){
	vec2 res = getResuolution();
	pos = floor(pos * res + off) / res;
	if(max(abs(pos.x - 0.5), abs(pos.y - 0.5)) > 0.5) {
		return vec3(0.0, 0.0, 0.0);
	}
	return texture(inTex, pos.xy).rgb;
}

vec4 fetchAll(vec2 pos,vec2 off){
	vec2 res = getResuolution();
	pos = floor(pos * res + off) / res;
	if(max(abs(pos.x - 0.5), abs(pos.y - 0.5)) > 0.5) {
		return vec4(0.0);
	}
	return texture(inTex, pos.xy);
}

// Calculates the distance of the emulated pixel to the neares text
vec2 dist(vec2 pos){
	vec2 res = getResuolution();
	pos = pos * res;
	return -((pos - floor(pos)) - vec2(0.5));
}
    
// 1D Gaussian.
float gauss(float pos, float scale){
	return exp2(scale * pos * pos);
}

// Return scanline weight.
float scan(vec2 pos, float off){
	float dst = dist(pos).y;
	return gauss(dst + off, i_hardScan);
}
// Return scanline weight for bloom.
float scanBloom(vec2 pos, float off){
  float dst = dist(pos).y;
  return gauss(dst + off, i_hardBloomScan);}

vec2 warp(vec2 pos){
	vec2 warp = vec2(1.0/i_warpX, 1.0/i_warpY);
	pos = pos * 2.0-1.0;    
	pos *= vec2(1.0+(pos.y * pos.y) * warp.x, 1.0 + (pos.x * pos.x) * warp.y);
	return pos * 0.5 + 0.5;
}

///=============================

// 3-tap Gaussian filter along horz line.
vec3 gaussHori3(vec2 pos, float off){

	vec3 b = fetch(pos, vec2(-1.0, off));
	vec3 c = fetch(pos, vec2( 0.0, off));
	vec3 d = fetch(pos, vec2( 1.0, off));
	float dst = dist(pos).x;
	
  // Convert distance to weight.
	float scale = i_hardPix;
	float wb = gauss(dst - 1.0, scale);
	float wc = gauss(dst + 0.0, scale);
	float wd = gauss(dst + 1.0, scale);
	
  // Return filtered sample.
	return (b * wb + c * wc + d * wd)/(wb + wc + wd);
 }

// 5-tap Gaussian filter along horz line.
vec3 gaussHori5(vec2 pos, float off){
	vec3 a = fetch(pos, vec2(-2.0, off));
	vec3 b = fetch(pos, vec2(-1.0, off));
	vec3 c = fetch(pos, vec2( 0.0, off));
	vec3 d = fetch(pos, vec2( 1.0, off));
	vec3 e = fetch(pos, vec2( 2.0, off));
	float dst = dist(pos).x;
  // Convert distance to weight.
	float scale = i_hardPix;
	float wa = gauss(dst - 2.0, scale);
	float wb = gauss(dst - 1.0, scale);
	float wc = gauss(dst + 0.0, scale);
	float wd = gauss(dst + 1.0, scale);
	float we = gauss(dst + 2.0, scale);
  // Return filtered sample.
	return (a * wa + b * wb + c * wc + d * wd + e * we)/(wa + wb + wc + wd + we);
}
vec3 gaussHori5B(vec2 pos, float off){
	vec3 a = fetch(pos, vec2(-2.0, off));
	vec3 b = fetch(pos, vec2(-1.0, off));
	vec3 c = fetch(pos, vec2( 0.0, off));
	vec3 d = fetch(pos, vec2( 1.0, off));
	vec3 e = fetch(pos, vec2( 2.0, off));
	float dst = dist(pos).x;
  // Convert distance to weight.
	float scale = 0;
	float wa = gauss(dst - 2.0, scale);
	float wb = gauss(dst - 1.0, scale);
	float wc = gauss(dst + 0.0, scale);
	float wd = gauss(dst + 1.0, scale);
	float we = gauss(dst + 2.0, scale);
  // Return filtered sample.
	return (a * wa + b * wb + c * wc + d * wd + e * we)/(wa + wb + wc + wd + we);
}
// 7-tap Gaussian filter along horz line.
vec3 gaussHori7(vec2 pos, float off){
	vec3 a = fetch(pos, vec2(-3.0, off));
	vec3 b = fetch(pos, vec2(-2.0, off));
	vec3 c = fetch(pos, vec2(-1.0, off));
	vec3 d = fetch(pos, vec2( 0.0, off));
	vec3 e = fetch(pos, vec2( 1.0, off));
	vec3 f = fetch(pos, vec2( 2.0, off));
	vec3 g = fetch(pos, vec2( 3.0, off));
	float dst = dist(pos).x;
  // Convert distance to weight.
	float scale = 0;
	float wa = gauss(dst - 3.0, scale);
	float wb = gauss(dst - 2.0, scale);
	float wc = gauss(dst - 1.0, scale);
	float wd = gauss(dst + 0.0, scale);
	float we = gauss(dst + 1.0, scale);
	float wf = gauss(dst + 2.0, scale);
	float wg = gauss(dst + 3.0, scale);
  // Return filtered sample.
	return (a * wa + b * wb + c * wc + d * wd + e * we + f * wf + g * wg)/(wa + wb + wc + wd + we + wf + wg);
}

// Small bloom.
vec3 bloom(vec2 pos){
	vec3 a = gaussHori3(pos, -2.0);
	vec3 b = gaussHori5(pos, -1.0);
	vec3 c = gaussHori7(pos, 0.0);
	vec3 d = gaussHori5(pos, 1.0);
	vec3 e = gaussHori3(pos, 2.0);
	
	float wa = scanBloom(pos, -2.0);
	float wb = scanBloom(pos, -1.0);
	float wc = scanBloom(pos, 0.0);
	float wd = scanBloom(pos, 1.0);
	float we = scanBloom(pos, 2.0);
	return (a * wa + b * wb + c * wc + d * wd + e * we);
}


// Allow nearest three lines to affect pixel.
vec3 scanlineV1(vec2 pos){
	vec3 a = gaussHori3(pos, -1.0);
	vec3 b = gaussHori5(pos, 0.0);
	vec3 c = gaussHori3(pos, 1.0);
	
	float wa = scan(pos, -1.0);
	float wb = scan(pos, 0.0);
	float wc = scan(pos, 1.0);
	return (a * wa + b * wb + c * wc);//
}
// Very compressed TV style shadow mask.
vec3 maskCompressedTV(vec2 pos){
	pos = floor(pos / i_maskSize);
	float line = i_maskLight;
	float odd = 0.0;
	
	if(fract(pos.x / 6.0) < 0.5) {
		odd = 1.0;
	}
	
	if(fract((pos.y + odd) / 2.0) < 0.5) {
		line = i_maskDark;  
	}
	
	pos.x = fract(pos.x / 3.0);
	vec3 mask = vec3(i_maskDark, i_maskDark, i_maskDark);
	
	if(pos.x < 0.333) {
		mask.r = i_maskLight;
	}
	else if(pos.x < 0.666) {
		mask.g = i_maskLight;
	}
	else{
		mask.b = i_maskLight;
	}
	mask *= line;
	return mask;
}        



// Aperture-grille.
vec3 maskApertureGrille(vec2 pos)
{
	pos = floor(pos / i_maskSize);
	pos.x = fract(pos.x / 3.0);
	vec3 mask = vec3(i_maskDark, i_maskDark, i_maskDark);
	
	if(pos.x < 0.333) {
		mask.r = i_maskLight;
	}
	else if(pos.x < 0.666) {
		mask.g = i_maskLight;
	}
	else{
		mask.b = i_maskLight;
	}
	return mask;
}        


// Stretched VGA style shadow mask (same as prior shaders).
vec3 maskStrechedVGA(vec2 pos){
	pos = floor(pos / i_maskSize);
	pos.x += pos.y * 3.0;
	vec3 mask = vec3(i_maskDark, i_maskDark, i_maskDark);
	pos.x = fract(pos.x/6.0);

	if(pos.x < 0.333) {
		mask.r = i_maskLight;
	}
	else if(pos.x < 0.666) {
		mask.g = i_maskLight;
	}
	else{
		mask.b = i_maskLight;
	}
	return mask;
}    



// VGA style shadow mask.
vec3 maskVGA(vec2 pos){
	pos = floor(pos / i_maskSize);
	pos.xy = floor(pos.xy * vec2(1.0, 0.5));
	pos.x += pos.y * 3.0;
	vec3 mask = vec3(i_maskDark, i_maskDark, i_maskDark);
	pos.x = fract(pos.x / 6.0);
	
	if(pos.x < 0.333) {
		mask.r = i_maskLight;
	}
	else if(pos.x < 0.666) {
		mask.g = i_maskLight;
	}
	else{
		mask.b = i_maskLight;
	}
	return mask;
}    

vec3 maskPhosphor(vec2 pos) {
	pos = floor(pos / i_maskSize);
	vec3 mask = vec3(i_maskDark, i_maskDark, i_maskDark);
	float CGWG = 0.40;     // CGWG Mask Strength
	pos.x = fract(pos.x * 0.5);
	float mc = 1.0 - CGWG;
	
	if (pos.x < 0.5) { 
		mask.r = 1.1;
		mask.g = mc; 
		mask.b = 1.1; 
	}
	
	else { 
		mask.r = mc; 
		mask.g = 1.1; 
		mask.b = mc; 
	}
	return mask;
}

vec4 maskApertureGrille2(vec2 pos)
{
	//Pattern:
	// R | BM | G | BM | B | BM |
	// B = Blue
	// BM = Black Matrix
	// G = Green
	// R = Red
	
	//calculate the position based off of the resolution
	//vec2 position = pos / i_resolution.xy;
	
	//get the scanline for this position
	//vec3 scanlineVec = getScanline_version1(position);
	
	//returns the current pixel blurred in the y axis with 
	//an adjustable input parameter to simulate the 
	//electron guns going accross the screen
	//vec4 _blur = __blur(); 
	
	//a bloom is used as baseline color
	//vec3 color = bloom(pos.xy);
	
	//color += _blur.rgb;
	//color *= scanlineVec;
	vec3 color = texture(inTex, pos.xy).rgb;
	//texture(iChannel0, pos.xy).rgb;
	pos = floor(pos / i_maskSize);
	pos.x = fract(pos.x / 3.0);
	
	vec4 mask = vec4(0);
	
	if(pos.x < 0.333) 
	{
		mask.r = i_maskLight;
		mask.g = i_maskDark;
		mask.b = i_maskDark;
		mask.rgb*=color;
	}
	else if(pos.x < 0.666) 
	{
		mask.r = i_maskDark;
		mask.b = i_maskDark;
		mask.g = i_maskLight;
		mask.rgb*=color;
		
	}
	else{
		mask.r = i_maskDark;
		mask.g = i_maskDark;
		mask.b = i_maskLight;
		mask.rgb*=color;
	}

	//based on the current fragment position
	//we give the pixel the sampled color of our input image
	//if(pos.x < (1.0 / 6.0)) // (1 / 6)
	//{
	//	mask.r =  color.r ; 
	//}
//
	//else if(pos.x < (2.0 / 6.0)) // (2 / 6)
	//{
	//	mask = vec4(i_maskDark);
	//	//mask.r =  color.r ;
	//}
//
	//else if(pos.x < (3.0 / 6.0)) // (3 / 6)
	//{
	//	mask.g =  color.g ;  
	//} 
//
	//else if(pos.x < (4.0 / 6.0)) // (4 / 6)
	//{
	//	mask = vec4(i_maskDark);
	//	//mask.g =  color.g ; 
	//}
//
	//else if(pos.x < (5.0 / 6.0)) // (5 / 6)
	//{
	//	mask.b =  color.b ; 
	//}
//
	//else // (6 / 6)
	//{ 
	//	mask = vec4(i_maskDark);
	//	//mask.b =  color.b ; 
	//}
	
	mask.a = 1; //_blur.a;
	mask.rgb *= vec3(i_maskLight);
	return mask;
}

//Pattern:
// R | BM | G | BM | B | BM | R | BM
// BM | BM | BM | BM | BM | BM | BM | BM | 
// BM | B | BM | R | BM | G | BM | B
vec4 maskDot(vec2 pos)
{
	//scaling doesnt really work with this one... 
	// probably because of the weird fractions which result
	//vec3 scanlineVec = getScanline_version1(pos/ i_resolution.xy);
	//vec4 _blur = __blur();
	//vec3 color = bloom(pos/ i_resolution.xy);
	//color += _blur.rgb;
	//color *= scanlineVec;
	
	
	
	pos = floor(pos / i_maskSize);
	
	pos.x = fract(pos.x / 8.0);
	pos.y = fract(pos.y / 2.0);
	//pos.x = fract(pos.x / 6.0);
	
	vec4 mask = vec4(0);

	// R | BM | G | BM | B | BM | R | BM
	if(pos.y < 0.5)
	{
		if(pos.x < (1.0 / 8.0)) //R
		{
			mask.r = i_maskLight;
		}
		else if(pos.x < (2.0 / 8.0)) // BM
		{
			mask = vec4(i_maskDark);
		} else if(pos.x < (3.0 / 8.0)) //G
		{
			mask.g = i_maskLight;
		}else if(pos.x < (4.0 / 8.0)) // BM
		{
			mask = vec4(i_maskDark);
		}else if(pos.x < (5.0 / 8.0)) //B
		{
			mask.b = i_maskLight;
		}else if(pos.x < (6.0 / .0)) //BM
		{
			mask = vec4(i_maskDark);
		}else if(pos.x < (7.0 / 8.0)) //R
		{
			mask.r = i_maskLight;
		}else
		{
			mask = vec4(i_maskDark);
		}
	}
	
	else
	{
		if(pos.x < (1.0 / 8.0)) //BM
		{
			mask = vec4(i_maskDark);
		}
		else if(pos.x < (2.0 / 8.0)) // B
		{
			mask.b = i_maskLight;
		} else if(pos.x < (3.0 / 8.0)) //BM
		{
			mask = vec4(i_maskDark);
		}else if(pos.x < (4.0 / 8.0)) // R
		{
			mask.r = i_maskLight;
		}else if(pos.x < (5.0 / 8.0)) //BM
		{
			mask = vec4(i_maskDark);
		}else if(pos.x < (6.0 / 8.0)) //G
		{
			mask.g = i_maskLight;
		}else if(pos.x < (7.0 / 8.0)) //BM
		{
			mask = vec4(i_maskDark);
		}else //B
		{ 
			mask.b = i_maskLight;
		}
	}
	
	mask.a = 1;//_blur.a;
	return mask;
}

//https://www.shadertoy.com/view/4sc3D7
const float LuminancePreservationFactor = 1.0;

const float PI2 = 6.2831853071;

// Valid from 1000 to 40000 K (and additionally 0 for pure full white)
vec3 colorTemperatureToRGB(const in float temperature){
  // Values from: http://blenderartists.org/forum/showthread.php?270332-OSL-Goodness&p=2268693&viewfull=1#post2268693   
  mat3 m = (temperature <= 6500.0) ? mat3(vec3(0.0, -2902.1955373783176, -8257.7997278925690),
	                                      vec3(0.0, 1669.5803561666639, 2575.2827530017594),
	                                      vec3(1.0, 1.3302673723350029, 1.8993753891711275)) : 
	 								 mat3(vec3(1745.0425298314172, 1216.6168361476490, -8257.7997278925690),
   	                                      vec3(-2666.3474220535695, -2173.1012343082230, 2575.2827530017594),
	                                      vec3(0.55995389139931482, 0.70381203140554553, 1.8993753891711275)); 
  return mix(clamp(vec3(m[0] / (vec3(clamp(temperature, 1000.0, 40000.0)) + m[1]) + m[2]), vec3(0.0), vec3(1.0)), vec3(1.0), smoothstep(1000.0, 0.0, temperature));
}


const float _gamma = 2.2;
vec3 gamma(vec3 color)
{
	return pow(color, vec3(1.0 / _gamma, 1.0 / _gamma, 1.0 / _gamma));
}
vec2 do_warp(vec2 pos){
	vec2 warp = vec2(1.0/i_warpX, 1.0/i_warpY);
	pos = pos * 2.0-1.0;    
	pos *= vec2(1.0+(pos.y * pos.y) * warp.x, 1.0 + (pos.x * pos.x) * warp.y);
	return pos * 0.5 + 0.5;
}

void main()
{
	vec2 pos = do_warp(gl_FragCoord.xy / i_resolution.xy);
	
	//if(i_enaWarp == 0) {
	//vec2 pos = gl_FragCoord.xy / i_resolution.xy;
	//}
	
	vec3 mask = vec3(1.0); //no mask
	
	//generate mask -> can be optimized still
	if (i_maskType == 1){ //compressed tv
		mask = maskCompressedTV(gl_FragCoord.xy * 1.0001);
		
	} else if(i_maskType == 2){ //aperture grille
		mask = maskApertureGrille(gl_FragCoord.xy * 1.0001);
		
	} else if (i_maskType == 3){ //stretched vga
		mask = maskStrechedVGA(gl_FragCoord.xy * 1.0001);
		
	} else if(i_maskType == 4) { //vga
		mask = maskVGA(gl_FragCoord.xy * 1.0001);
		
	} else if(i_maskType == 5){ //phosphor
		mask = maskPhosphor(gl_FragCoord.xy * 1.0001);
	
    } else if(i_maskType == 6){
        mask = maskApertureGrille2(gl_FragCoord.xy).rgb;
    
    } else if(i_maskType == 7){
        mask = maskDot(gl_FragCoord.xy * 1.0001).rgb;
    }
	vec4 fragColor = vec4(1);
	fragColor.rgb = mask;
	
	//calculate scanline
	vec3 scanLine = scanlineV1(pos);
	
	//if(i_enaDrawMask == 0) {
		
		fragColor.rgb *= scanLine;
		//fragColor.rgb = saturation(fragColor.rgb);
		//Bloom
		// Normalized exposure.
		fragColor.rgb = mix(fragColor.rgb, bloom(pos), i_bloomAmount);    
		//Additive bloom
		//fragColor.rgb += bloom(pos) * i_bloomAmount;   
	//}
	fragColor.a = 1.0;
	FragColor = fragColor;
}	
