#version 450 core

in vec2 TexCoords;

uniform sampler2D colorTexture;
uniform sampler2D lookupTableTexture0;
uniform sampler2D lookupTableTexture1;

out vec4 fragColor;

void main() {
  vec2 texSize = textureSize(colorTexture, 0).xy;
  float gamma = 2.2;
  vec4 color = texture(colorTexture, TexCoords);
  vec4 _color = color;
  
  vec3 S1 = sqrt(color.rgb);
  vec3 S2 = sqrt(S1);
  vec3 S3 = sqrt(S2);
  color.rgb = 0.585122381 * S1 + 0.783140355 * S2 - 0.368262736 * S3;

   float u  =  floor(color.b * 15.0) / 15.0 * 240.0;
        u  = (floor(color.r * 15.0) / 15.0 *  15.0) + u;
        u /= 255.0;
  float v  = 1.0 - (floor(color.g * 15.0) / 15.0);

  vec3 left0 = texture(lookupTableTexture0, vec2(u, v)).rgb;
  vec3 left1 = texture(lookupTableTexture1, vec2(u, v)).rgb;

  u  =  ceil(color.b * 15.0) / 15.0 * 240.0;
  u  = (ceil(color.r * 15.0) / 15.0 *  15.0) + u;
  u /= 255.0;
  v  = 1.0 - (ceil(color.g * 15.0) / 15.0);

  vec3 right0 = texture(lookupTableTexture0, vec2(u, v)).rgb;
  vec3 right1 = texture(lookupTableTexture1, vec2(u, v)).rgb;

  float sunPosition = sin(1 * 3.1415);
        sunPosition = 0.5 * (sunPosition + 1);

  vec3 left  = mix(left0,  left1,  0.5);
  vec3 right = mix(right0, right1, 0.5);

  color.r = mix(left.r, right.r, fract(color.r * 15.0));
  color.g = mix(left.g, right.g, fract(color.g * 15.0));
  color.b = mix(left.b, right.b, fract(color.b * 15.0));
  
  //color.rgb = pow(color.rgb, vec3(gamma));
  color.rgb = color.rgb * (color.rgb * (color.rgb * 0.305306011 + 0.682171111) + 0.012522878);
  fragColor = color;
}