#version 450 core
#extension GL_KHR_vulkan_glsl : require
layout (location = 0) in vec3 position;
layout (location = 2) in vec2 aTexCoord;
layout (location = 4) uniform mat4 modelMatrix;
layout (location = 5) uniform mat4 projMatrix;
layout (location = 6) uniform mat4 viewMatrix;

out vec2 TexCoord;
out mat4 fragView;
out mat4 fragProj;

layout(location = 7) out vec3 nearPoint;
layout(location = 8) out vec3 farPoint;


vec3 UnprojectPoint(float x, float y, float z, mat4 view, mat4 projection) {
    mat4 viewInv = inverse(view);
    mat4 projInv = inverse(projection);
    vec4 unprojectedPoint =  viewInv * projInv * vec4(x, y, z, 1.0);
    return unprojectedPoint.xyz / unprojectedPoint.w;
}

void main() {
	vec3 p = position;
    nearPoint = UnprojectPoint(p.x, p.y, 0.0, viewMatrix, projMatrix).xyz; // unprojecting on the near plane
    farPoint = UnprojectPoint(p.x, p.y, 1.0, viewMatrix, projMatrix).xyz; // unprojecting on the far plane
	fragView = viewMatrix;
	fragProj = projMatrix;
	TexCoord = aTexCoord;
	gl_Position = vec4(p, 1.0); // using directly the clipped coordinates
}