#version 450 core

layout (location = 1) uniform vec3 vertexColor;
layout(location = 7) in vec3 nearPoint;
layout(location = 8) in vec3 farPoint;
in mat4 fragView;
in mat4 fragProj;

out vec4 outColor;
uniform sampler2D ourTexture;
in vec2 TexCoord;

vec4 grid(vec3 fragPos3D, float scale, bool drawAxis) {
    vec2 coord = fragPos3D.xz * scale;
    vec2 derivative = fwidth(coord);
    vec2 grid = abs(fract(coord - 0.5) - 0.5) / derivative;
    float line = min(grid.x, grid.y);
    float minimumz = min(derivative.y, 1);
    float minimumx = min(derivative.x, 1);
    vec4 color = vec4(0.1, 0.2, 0.1, 1.0 - min(line, 1.0));
    // z axis
    if(fragPos3D.x > -100.1 * minimumx && fragPos3D.x < 100.1 * minimumx)
        color.z = 1.0;
    // x axis
    if(fragPos3D.z > -100.1 * minimumz && fragPos3D.z < 100.1 * minimumz)
        color.x = 1.0;
    return color;
}
float computeDepth(vec3 pos) {
    vec4 clip_space_pos = fragProj * fragView * vec4(pos.xyz, 1.0);
    return (clip_space_pos.z / clip_space_pos.w);
}
float computeLinearDepth(vec3 pos) {
	float near = 0.2;
	float far = 5000.0;
    vec4 clip_space_pos = fragProj * fragView * vec4(pos.xyz, 1.0);
    float clip_space_depth = (clip_space_pos.z / clip_space_pos.w) * 2.0 - 1.0; // put back between -1 and 1
    float linearDepth = (2.0 * near * far) / (far + near - clip_space_depth * (far - near)); // get linear value between 0.01 and 100
    return linearDepth / far; // normalize
}
void main() {
    float t = -nearPoint.y / (farPoint.y - nearPoint.y);
    vec3 fragPos3D = nearPoint + t * (farPoint - nearPoint);

    gl_FragDepth = computeDepth(fragPos3D);

    float linearDepth = computeLinearDepth(fragPos3D);
    float fading = max(0, (0.5 - linearDepth));

    vec4 texColor = ( grid(fragPos3D, 0.01, true) + grid(fragPos3D, 0.001, true))* float(t > 0); // adding multiple resolution for the grid
    texColor.a *= fading;
	
	//if(texColor.a < 0.1)
    //    discard;
	outColor = texColor;
}