#version 450 core

layout (location = 0) in vec3 aPosition;
layout (location = 1) in vec3 aNormal;
layout (location = 2) in vec2 aTexcoord;
layout (location = 3) in vec3 aTangent;
layout (location = 4) in vec3 aBitangent;

layout (location = 5) uniform mat4 modelMatrix;
layout (location = 6) uniform mat4 projMatrix;
layout (location = 7) uniform mat4 viewMatrix;

uniform mat3 normalMatrix;
uniform vec3 viewPosition;
uniform mat4 lightSpaceMatrix;

out vec4 FragPos;
out vec2 TexCoords;
out vec3 Normal;
out vec3 Tangent;
out vec4 FragPosLightSpace; 
out vec4 FragPosViewSpace; //in view space
out vec3 NormalNonLightSpace; //in view space

void main()
{
    vec4 worldPos = modelMatrix * vec4(aPosition, 1.0);
    FragPos = worldPos; 
	FragPosViewSpace = viewMatrix * worldPos;
    TexCoords = aTexcoord;
    Tangent = aTangent;
	FragPosLightSpace = lightSpaceMatrix * worldPos;
	
    mat3 normalMatrix = transpose(inverse(mat3(modelMatrix)));
    Normal = normalMatrix * aNormal;
	
	mat3 normalMatrix2 = transpose(inverse(mat3(viewMatrix * modelMatrix)));
	NormalNonLightSpace = normalMatrix2 * aNormal;
    gl_Position = projMatrix * viewMatrix * worldPos;
}