#version 450 core

layout (location = 0) out vec4 gPosition;
layout (location = 1) out vec3 gNormal;
layout (location = 2) out vec4 gAlbedoSpec;
layout (location = 3) out vec4 gFragPosLight;
layout (location = 4) out vec3 gNormalNonLightSpace;
layout (location = 5) out vec4 gFragPosViewSpace;

in vec2 TexCoords;
in vec4 FragPos;
in vec3 Normal;
in vec3 Tangent;
in vec4 FragPosLightSpace;
in vec3 NormalNonLightSpace;
in vec4 FragPosViewSpace;

layout (location = 5) uniform mat4 modelMatrix;

struct Material {
	sampler2D diffuseTex;
	sampler2D roughnessTex;
	sampler2D normalTex;
	
	vec3 diffuseColor;
    vec3 ambient;
    vec3 specular;
    float shininess;
	float roughness;
}; 

uniform Material material;

vec3 createTBN(vec3 norm)
{
	vec3 T = normalize(vec3(modelMatrix * vec4(Tangent, 0.0)));
	vec3 _N = normalize(vec3(modelMatrix * vec4(norm, 0.0)));
	T = normalize(T - dot(T, _N) * _N);
	vec3 B = cross(_N, T);

	mat3 TBN = mat3(T, B, _N);  
	vec3 _normalTex = texture(material.normalTex, TexCoords).rgb;
	vec3 normal = TBN * _normalTex;
	normal = normalize(normal * 2.0 - 1.0);
	return normalize(normal);
	
}

void main()
{
	
	vec3 N = createTBN(Normal);
	vec3 N2 = createTBN(NormalNonLightSpace);
	gPosition = FragPos;
    
	gNormal = N;
	gNormalNonLightSpace = N2;
	
    gAlbedoSpec.rgb = texture(material.diffuseTex, TexCoords).rgb;
    gAlbedoSpec.a = texture(material.roughnessTex, TexCoords).r;
	
	gFragPosLight = FragPosLightSpace;
	gFragPosViewSpace = FragPosViewSpace;
}