#version 450 core

in vec2 TexCoords;

uniform sampler2D colorTexture;

uniform vec2 mouseFocusPoint;

out vec4 fragColor;

void main() {
  float redOffset   =  0.009;
  float greenOffset =  0.006;
  float blueOffset  = -0.006;

  //vec2 texSize  = textureSize(colorTexture, 0).xy;
  //vec2 texCoord = gl_FragCoord.xy / texSize;

  vec2 direction = TexCoords - mouseFocusPoint;

  fragColor = texture(colorTexture, TexCoords);

  fragColor.r = texture(colorTexture, TexCoords + (direction * vec2(redOffset  ))).r;
  fragColor.g = texture(colorTexture, TexCoords + (direction * vec2(greenOffset))).g;
  fragColor.b = texture(colorTexture, TexCoords + (direction * vec2(blueOffset ))).b;
}