#version 450 core

layout (location = 0) in vec3 aPosition;
layout (location = 1) in vec3 aNormal;
layout (location = 2) in vec2 aTexcoord;
layout (location = 3) in vec3 aTangent;
layout (location = 4) in vec3 aBitangent;

layout (location = 5) uniform mat4 modelMatrix;
layout (location = 6) uniform mat4 projMatrix;
layout (location = 7) uniform mat4 viewMatrix;

out vec2 TexCoords;

void main()
{
	TexCoords = aTexcoord;
	gl_Position = projMatrix * viewMatrix * modelMatrix * vec4(aPosition, 1.0f);
}