#version 430 core

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normal;
layout(location = 2) in vec2 uv;

out VertexData {
    vec3 position_world;
    vec3 normal_world;
    vec2 uv;
} vert;

uniform mat4 modelMatrix;
uniform mat4 viewProjMatrix;
uniform mat3 normalMatrix;

uniform float time;

float GetYOffset(vec3 positionWorld, float time) {
    float aFac = 1.5;
    float fFac = 115;
    float sFac = 2;
    float waveAmplitude1 = 0.001;
    float waveAmplitude2 = 0.002;
    float waveAmplitude3 = 0.005;
    float waveAmplitude4 = 0.005;
    float waveAmplitude5 = 0.01;
    float waveAmplitude6 = 0.01;
    float waveFrequency2 = 25.0;
    float waveFrequency1 = 25.0;
    float waveFrequency3 = 10.0;
    float waveFrequency4 = 10.0;
    float waveFrequency5 = 5.0;
    float waveFrequency6 = 5.0;
    float waveSpeed1 = 0.1;
    float waveSpeed2 = 0.1;
    float waveSpeed3 = 0.2;
    float waveSpeed4 = 0.2;
    float waveSpeed5 = 1.0;
    float waveSpeed6 = 1.0;
    float waveAmplitude7 = 0.005;
    float waveAmplitude8 = 0.002;
    float waveFrequency7 = 7.0;
    float waveFrequency8 = 3.0;
    float waveSpeed7 = 0.5;
    float waveSpeed8 = 0.8;
    

    float offset = 0.0;
    offset += aFac * waveAmplitude1 * cos(waveFrequency1 * fFac * positionWorld.x + waveSpeed1 * sFac * time + positionWorld.x);
    offset += aFac * waveAmplitude2 * sin(waveFrequency2 * fFac * positionWorld.z + waveSpeed2 * sFac * time + positionWorld.y);
    offset += aFac * waveAmplitude3 * sin(waveFrequency3 * fFac * positionWorld.x + waveSpeed3 * sFac * time + positionWorld.z);
    offset += aFac * waveAmplitude4 * cos(waveFrequency4 * fFac * positionWorld.z + waveSpeed4 * sFac * time + positionWorld.x);
    offset += aFac * waveAmplitude5 * cos(waveFrequency5 * fFac * positionWorld.x + waveSpeed5 * sFac * -time + positionWorld.y);
    offset += aFac * waveAmplitude6 * sin(waveFrequency6 * fFac * positionWorld.z + waveSpeed6 * sFac * -time + positionWorld.y);
    offset += aFac * waveAmplitude7 * sin(waveFrequency7 * fFac * positionWorld.z + waveSpeed7 * sFac * time + positionWorld.y);
    offset += aFac * waveAmplitude8 * cos(waveFrequency8 * fFac * positionWorld.x + waveSpeed8 * sFac * time + positionWorld.z);
    return offset;
}

vec3 CalculateNormal(vec3 positionWorld) {
    float eps = 0.5;
float offset = GetYOffset(positionWorld, time);
vec3 normal = vec3(
	GetYOffset(positionWorld + vec3(eps, 0, 0), time) - offset,
	eps,
	GetYOffset(positionWorld + vec3(0, 0, eps), time) - offset
);
return normalize(normal);
}



void main() {
    vec4 positionWorld = vec4(position,1);

    // layered waves with offsets
    positionWorld.y += GetYOffset(positionWorld.xyz, time);

    vec4 positionView = viewProjMatrix * modelMatrix * positionWorld;
    gl_Position = positionView;

    vec3 calcNormal = CalculateNormal(positionWorld.xyz);
    vec3 normalWorld = normalize(normalMatrix * calcNormal);
    vert.normal_world = normalWorld;
    vert.uv = uv;

    vec4 position_world_ = modelMatrix * vec4(position, 1);
    vert.position_world = position_world_.xyz;
}
