#version 450
#extension GL_EXT_scalar_block_layout: require
#extension GL_EXT_buffer_reference2 : require
#extension GL_EXT_scalar_block_layout : enable
	
struct PerFrameData
{
	mat4 viewMatrix;
	mat4 projectionMatrix;
	mat4 invViewMatrix;
	mat4 invProjectionMatrix;
};


layout (buffer_reference, scalar) buffer Positions
{
	vec3 positions[];
};

layout (buffer_reference ,scalar) buffer Normals
{
	vec3 normals[];
};

layout (buffer_reference, scalar) buffer TextureCoords
{
	vec2 uvs[];
};



layout (set = 1, binding = 0) uniform UniformBlock { PerFrameData frame; };

layout (push_constant, std430) uniform PushConsts 
{
	Positions positionBuffer;
	Normals normalBuffer;
	TextureCoords uvCoords;

	mat4 modelMatrix;
	uint textureId;
} pushConstants;


layout(location = 0) out vec2 outUV;
layout(location = 1) out vec3 outNormalVS;
layout(location = 2) out vec3 outPosWS;
layout(location = 3) out vec3 outNormalWS;


mat4 projection(float vertical_fov, float aspect_ratio, float near)
{
	float fov_rad = vertical_fov * 2.0f * 3.1415926535 / 360.0f;
	float focal_length = 1.0f / tan(fov_rad / 2.0f);

	float x = focal_length / aspect_ratio;
	float y = -focal_length;
	float A = 0;//-near/(near-far);
	float B = near;//(-near*far)/(near-far);

	return mat4(
		x, 0, 0, 0,
		0, y, 0, 0,
		0, 0, A, 1,
		0, 0, B, 0
	);
}


void main() {
	outUV = pushConstants.uvCoords.uvs[gl_VertexIndex];

	vec3 normalOS = pushConstants.normalBuffer.normals[gl_VertexIndex];
	mat4 vmMatrix = frame.viewMatrix * pushConstants.modelMatrix;
	mat3 vmNormalMatrix = mat3(inverse(transpose(vmMatrix)));
	outNormalVS = vmNormalMatrix * normalOS;
	outNormalWS = mat3(inverse(transpose(pushConstants.modelMatrix))) * normalOS;

	mat4 proj = projection(60.0, 1280.0/720.0, 0.1);

	vec3 v = pushConstants.positionBuffer.positions[gl_VertexIndex];
	vec4 posWS = pushConstants.modelMatrix * vec4(v, 1.0);
	outPosWS = posWS.xyz;
	gl_Position = proj * frame.viewMatrix * posWS;

}