#version 440 core

layout (points) in;
layout (triangle_strip, max_vertices = 4) out;
uniform int lin;
in int character[];
in int num[];

out vec2 uv;


vec2 fontMapRes = vec2(1024, 383);
vec2 fontMapSize = vec2(16, 6);
vec2 glyphSize = 1.0f / fontMapSize;

vec2 get_uv() {
    float i = mod(character[0], fontMapSize.x);
    float j = floor(character[0]/fontMapSize.x);
    return vec2(i, j);
}

float s = 0.04f;
void move(float a, float b) {
    gl_Position = vec4(-0.9+float(num[0])/20.0f + a, -0.1f*lin+0.9+4.0f/3.0f*b, 1.0f, 1.0f);
    uv = glyphSize*(get_uv()+vec2(a / s,1.0f- b / s));
    EmitVertex();
}

void main() {
    
    // BACK
    move(0, 0);
    move(s, 0);
    move(0, s);
    move(s, s);
    EndPrimitive();

 



}    