#version 440 core

layout(triangles) in;
layout(triangle_strip, max_vertices = 3) out;

in float tes_height[];
in vec4 tes_position[];
in vec2 tes_coords[];
in float tes_tessLevel[];
layout(location = 2) uniform sampler2D heightMap;

out float gs_height;
out vec3 gs_H;
out vec3 gs_bcoord;
out vec4 gs_position;
out vec4 gs_normal;
out vec2 gs_coords;
out float gs_w;
out float gs_z;
out float gs_tessLevel;

void main(void)
{
    vec2 p0 = gl_in[0].gl_Position.xy / gl_in[0].gl_Position.w;
    vec2 p1 = gl_in[1].gl_Position.xy / gl_in[1].gl_Position.w;
    vec2 p2 = gl_in[2].gl_Position.xy / gl_in[2].gl_Position.w;

    float a = length(p1 - p2);
    float b = length(p2 - p0);
    float c = length(p1 - p0);
    float alpha = acos((b * b + c * c - a * a) / (2.0 * b * c));
    float beta = acos((a * a + c * c - b * b) / (2.0 * a * c));
    float ha = abs(c * sin(beta));
    float hb = abs(c * sin(alpha));
    float hc = abs(b * sin(alpha));

    gs_H = vec3(ha, hb, hc);

    vec3 r01 = (tes_position[1] - tes_position[0]).xyz;
    vec3 r02 = (tes_position[2] - tes_position[0]).xyz;
    gs_normal = normalize(vec4(cross(r01, r02), 1.0f));

    
    

    for (int i = 0; i < gl_in.length(); i++)
    {
        gs_bcoord = vec3(0.0f);
        gs_bcoord[i % 3] = 1.0f;
        gl_Position = gl_in[i].gl_Position;
        gs_height = tes_height[i];
        gs_position = tes_position[i];
        gs_coords = tes_coords[i];
        gs_w = gl_in[i].gl_Position.w;
        gs_z = gl_in[i].gl_Position.z;
        gs_tessLevel = tes_tessLevel[i];
        //gs_normal = vec4(normalize(getNormal(tes_position[i])), 1.0f);

        EmitVertex();
    }
    EndPrimitive();
}

