#version 440 core

uniform bool wireframeToggle;
layout(location = 2) uniform sampler2D heightMap;

uniform vec3 cam_pos;
uniform vec3 cam_target;
uniform vec3 cam_up;
uniform vec3 lt_pos;
uniform float time;


in float gs_height;
in vec3 gs_H;
in vec3 gs_bcoord;
in vec4 gs_position;
in vec4 gs_normal;
in vec2 gs_coords;
in float gs_w;
in float gs_z;
in float gs_tessLevel;
const vec3 c_atm = vec3(0.2f, 0.8f, 1.0f);
const float H_atm = 20000.0f;
const float dist_atm = 2.0f * H_atm;
const float size = 128.0f;
const float pixel = 1.0f / size;
const float pi = 3.14159265359;
const vec3 L = normalize(lt_pos);



out vec4 color;

float min3f(vec3 v) { return min(min(v.x, v.y), v.z); }

float getHeight(vec2 uv) {
	return texture(heightMap, uv).r;
}

float subSample(vec2 pos, float amp, float period) {
	vec2 uv = pos/period;
	vec2 uv_sub = mod(uv, pixel)/pixel;
	float val = getHeight(uv);
	float val_1 = getHeight(uv + pixel*vec2(0.0f,0.0f));
	float val_2 = getHeight(uv + pixel*vec2(1.0f,0.0f));
	float val_3 = getHeight(uv + pixel*vec2(0.0f,1.0f));
	float val_4 = getHeight(uv + pixel*vec2(1.0f,1.0f));
	return amp*mix(
		mix(val_1, val_2, uv_sub.x),
		mix(val_3, val_4, uv_sub.x),
		uv_sub.y
	);
}

float displace(vec2 pos) {
	float y = subSample(pos, 8000.0f, 128000.0f) +
		subSample(pos, 2500.0f, 32000.0f) -
		subSample(pos, 300.0f, 8000.0f) +
		subSample(pos, 30.0f, 2200.0f);
	y = y - 3000.0f;
	return y;
}




vec3 getNormal(vec2 pos) {
	float unit = 80.0f;
	float dydx = 0.5f*(displace(pos+unit*vec2(1.0f, 0.0f)) - displace(pos+unit*vec2(-1.0f, 0.0f)))/unit;
	float dydz = 0.5f*(displace(pos+unit*vec2(0.0f, 1.0f)) - displace(pos+unit*vec2(0.0f, -1.0f)))/unit;
	vec3 N = normalize(vec3(-dydx, 1.0f, -dydz));
	return N;
}

const vec2 dir[5] = { vec2(0.80901699437, 0.58778525229), vec2(0.30901699437, 0.95105651629), vec2(-0.30901699437, 0.95105651629), vec2(-0.80901699437, 0.58778525229), vec2(-0.86602540378, 0.5f) };
const float amp[5] = { 20.0f, 28.0f, 30.0f, 24.0f, 21.0f };
const float period[5] = { 190.0f, 211.0f, 122.0f, 360.0f, 140.0f };
const float speed[5] = { 1.7f, -2.0f, 3.2f, 2.4f, -3.11f };



vec3 getNormalWater(vec2 pos) {
	int i = 0;
	float Lxy = 0.0f;
	float Ly = 0.0f;
	float Lx = 0.0f;
	for (i; i<=4; i++){
		Lxy = amp[i] / period[i] * cos(speed[i] * time + (pos.x * dir[i].x + pos.y * dir[i].y) / period[i]);
		Lx += dir[i].x*Lxy;
		Ly += dir[i].y*Lxy;
	}

	return normalize(vec3(-Lx, 1.0f, -Ly));
}

const vec3 color_water = vec3(0.1f, 0.6f, 1.0f);
const vec3 color_snow = vec3(1.0f);
const vec3 color_grass = vec3(0.2f, 0.8f, 0.3f);
const vec3 color_rock = vec3(0.7);
const vec3 dir_up = vec3(0.0f, 1.0f, 0.0f);
const float i_diffuse = 0.7f;
const float i_ambient = 0.2;

vec3 light(vec2 pos) {
	

	float disp = displace(pos)/8000.0f;

	vec3 light_diffuse;
	vec3 N;



		

	if (disp < 0.0f) {
		if (-30.0f * disp > 1.0f) {
			light_diffuse = color_water;
		}
		else
		{light_diffuse = color_snow; }
		N = getNormalWater(pos);
	}
	else {

		N = getNormal(pos);
		float phi = acos(dot(N, dir_up));

		if (disp+cos(10.0f*phi)/10.0f > 0.2f) {
			light_diffuse = color_snow;

		}
		else {
			light_diffuse = mix(color_grass, color_rock, max(min(10.0f*disp, 1.0f), 0.0f));
		}
	}




	vec3 c = (i_ambient + i_diffuse * max(dot(L, N),0.0f) ) * light_diffuse;


	
	
	return c;
}

void main()
{

	vec2 p = gs_position.xz;
	vec3 c;


	c = light(p);


	float z = gl_FragCoord.z / gl_FragCoord.w;
	float a = clamp(1.0f - z / (2.0f*dist_atm), 0.0f, 1.0f);
	

	c = (a)*c + (1.0f-a)*c_atm;

	float k = 0.7f;
	c = k*c + (1.0f-k)*vec3(c.r+c.g+c.b)/3.0f;
	c = k * c + (1.0f - k) * color_snow;
	color = vec4(c, 1.0f);


	if (wireframeToggle) {
		float c = 0.002f;
		float c2 = 0.008f;
		float d = min3f(gs_H * gs_bcoord);
		
		vec2 D = 1.0f-2.0f*abs(0.5f - gs_coords);
		float d2 = min(D.x, D.y);


		if (d < c) {
			color = vec4(sin(0.5f * pi * d / c) * color.xyz, 1.0f);
		}


		if (d2 < c2*gs_w/6400.0f) {
			color = vec4(vec3(0.0f), 1.0f);
		}




	}
}