#version 440 core

layout(quads, equal_spacing, cw) in;


uniform mat4 M;
uniform mat4 V;
uniform mat4 P;
uniform mat4 MVP;
uniform float time;
layout(location = 2) uniform sampler2D heightMap;
uniform vec3 cam_pos;
uniform vec3 cam_target;
uniform vec3 cam_up;
uniform vec3 lt_pos;
uniform bool isWater;
in float tcs_tessLevel[];

out float tes_height;
out vec4 tes_position;
out vec2 tes_coords;
out float tes_tessLevel;
uniform int I;
uniform float sphere_radius;
uniform float scale;

const float size = 128.0f;
const float pixel = 1.0f / size;
const float pi = 3.14159265359;

const vec2 dir[5] = { vec2(0.80901699437, 0.58778525229), vec2(0.30901699437, 0.95105651629), vec2(-0.30901699437, 0.95105651629), vec2(-0.80901699437, 0.58778525229), vec2(-0.86602540378, 0.5f) };
const float amp[5] = { 20.0f, 28.0f, 30.0f, 24.0f, 21.0f };
const float period[5] = { 190.0f, 211.0f, 122.0f, 360.0f, 140.0f };
const float speed[5] = { 1.7f, -2.0f, 3.2f, 2.4f, -3.11f };

float displaceWater(vec2 pos) {
	int i = 0;
	float y = 0.0f;
	for (i; i<=4; i++){
		y += amp[i] * sin(speed[i]*time + (pos.x*dir[i].x+pos.y*dir[i].y)/period[i]);
	}
	return y;
}

float getHeight(vec2 uv) {
	return texture(heightMap, uv).r;
}

float subSample(vec2 pos, float amp, float period) {
	vec2 uv = pos/period;
	vec2 uv_sub = mod(uv, pixel)/pixel;
	float val = getHeight(uv);
	float val_1 = getHeight(uv + pixel*vec2(0.0f,0.0f));
	float val_2 = getHeight(uv + pixel*vec2(1.0f,0.0f));
	float val_3 = getHeight(uv + pixel*vec2(0.0f,1.0f));
	float val_4 = getHeight(uv + pixel*vec2(1.0f,1.0f));
	return amp*mix(
		mix(val_1, val_2, uv_sub.x),
		mix(val_3, val_4, uv_sub.x),
		uv_sub.y
	);
	
}


float displace(vec2 pos) {
	float y = subSample(pos, 8000.0f, 128000.0f) +
		subSample(pos, 2500.0f, 32000.0f) -
		subSample(pos, 300.0f, 8000.0f) +
		subSample(pos, 30.0f, 2200.0f);
	y = max(y - 3000.0f, 0.0f);
	return y;
}






void main()
{
	const float res = 2.0f*scale / I;
	vec3 offset_dis = res * vec3(floor(cam_pos.x / res+0.5f), 0.0f, floor(cam_pos.z / res+0.5f));
	vec3 offset_con = vec3(cam_pos.x, 0.0f, cam_pos.z);

    float u = gl_TessCoord.x;
    float v = gl_TessCoord.y;
    tes_coords = gl_TessCoord.xy;

    vec4 p00 = gl_in[0].gl_Position;
    vec4 p01 = gl_in[1].gl_Position;
    vec4 p10 = gl_in[2].gl_Position;
    vec4 p11 = gl_in[3].gl_Position;

    vec4 p0 = (p01 - p00) * u + p00;
    vec4 p1 = (p11 - p10) * u + p10;
    vec3 position = scale*((p1 - p0) * v + p0).xyz;
	
	vec3 pos_rel1 = position + offset_dis;
	vec3 pos_rel2 = pos_rel1 - offset_con;
	float radius = length(pos_rel2.xz);
	float curvature = sqrt(sphere_radius * sphere_radius - radius * radius) - sphere_radius;
	
	position.y = curvature;
	
	vec3 normal = normalize(pos_rel2 - vec3(0.0f, -sphere_radius, 0.0f));
	
	position += normal*(displace(pos_rel1.xz));
	if (position.y == curvature) {
	position += normal * (displaceWater(pos_rel1.xz));
	}
	

	tes_position = vec4(position+offset_dis, 1.0f);
    gl_Position = MVP * vec4(position+offset_dis, 1.0f);
    tes_tessLevel = tcs_tessLevel[0];
}