#version 440 core

uniform vec3 cam_pos;
uniform vec3 cam_target;
uniform vec3 cam_up;
uniform vec3 lt_pos;
uniform mat4 MVP;
uniform mat4 M;
uniform int I;

layout(vertices = 4) out;
out float tcs_tessLevel[];


void main()
{
    gl_out[gl_InvocationID].gl_Position = gl_in[gl_InvocationID].gl_Position;
    if (gl_InvocationID == 0)
    {

        vec4 p0 = gl_in[2].gl_Position;
        vec4 p1 = gl_in[0].gl_Position;
        vec4 p2 = gl_in[1].gl_Position;
        vec4 p3 = gl_in[3].gl_Position;

        vec4 pa = (p0 + p1) / 2.0f;
        vec4 pb = (p1 + p2) / 2.0f;
        vec4 pc = (p2 + p3) / 2.0f;
        vec4 pd = (p3 + p0) / 2.0f;

        float d0 = max(I*(sqrt(2.0f)/3.0f-length(pa.xz)), 1.0f);
        float d1 = max(I*(sqrt(2.0f)/3.0f-length(pb.xz)), 1.0f);
        float d2 = max(I*(sqrt(2.0f)/3.0f-length(pc.xz)), 1.0f);
        float d3 = max(I*(sqrt(2.0f)/3.0f-length(pd.xz)), 1.0f);

        d0 *= d0;
        d1 *= d1;
        d2 *= d2;
        d3 *= d3;


        d0 += 1.0f;
        d1 += 1.0f;
        d2 += 1.0f;
        d3 += 1.0f;

        gl_TessLevelOuter[0] = d0;
        gl_TessLevelOuter[1] = d1;
        gl_TessLevelOuter[2] = d2;
        gl_TessLevelOuter[3] = d3;

        gl_TessLevelInner[0] = (d0+d1+d2+d3)/4.0f;
        gl_TessLevelInner[1] = (d0+d1+d2+d3)/4.0f;
    }
    tcs_tessLevel[gl_InvocationID] = gl_TessLevelOuter[gl_InvocationID];
}