#version 440 core

in vec2 uv;
out vec4 color;

uniform vec3 cam_pos;
uniform vec3 cam_target;
uniform bool wireframeToggle;
uniform vec3 lt_pos;
uniform mat4 camera_matrix;
uniform mat4 V;


const float ASPECT = 4.0f / 3.0f;
const float alpha = radians(60.0f);
const float FACTOR = tan(alpha/2.0f);
const vec3 c_atm = vec3(0.2f, 0.8f, 1.0f);
const vec3 c_atm2 = vec3(0.6f, 0.9f, 1.0f);
const vec3 L = normalize(lt_pos);
const vec3 C = normalize(cam_target - cam_pos);
const vec3 N = normalize(vec3(0.0f, 1.0f, 0.0f));

void main()
{
	vec3 uv_prime = vec3(2.0f * uv - 1.0f, 1.0f);
	vec3 ray_direction = normalize(uv_prime*vec3(-ASPECT*FACTOR, FACTOR, 1.0f));

	ray_direction = normalize((camera_matrix*vec4(ray_direction, 0.0f)).xyz);
	//vec3 c = (ray_direction + 1.0f) / 2.0f;
	vec3 c = vec3(0.0f);




	
	vec3 R = ray_direction;
	
	float H_atm = 20000.0f;
	float dist_atm = H_atm;
	float d = max(H_atm - cam_pos.y, 0.0f)/dist_atm;
	float a = 1.0f;
	
	float R_earth = 637100.0f;
	//float H_atm = 20000.0f;

	float phi = acos(dot(R, N));
	float r0 = -((R_earth+cam_pos.y)/(2.0f*R_earth+H_atm));
	float r = 1.0f;
	float l = r0 * cos(phi) + sqrt(r * r - r0 * r0 * sin(phi) * sin(phi));

	c = l * c_atm;
	


	float ns = dot(ray_direction, normalize(lt_pos));

	c = mix(c, c_atm2, ns*ns);
	a = 1.0f;
	if (ns > 0.999f) {
		
		float k = min(2.0f*(ns - 0.999f)/(1.0f-0.999f), 1.0f);
		c = mix(c,vec3(1.0f), k);
	}
	
	color = vec4(c, a);
}