#version 440 core

layout (points) in;
layout (triangle_strip, max_vertices = 4) out;

in float vK[];
in float vLife[];
out float gsK;
out float gsLife;
out vec2 uv;

uniform mat4 MVP;
uniform float time;
uniform float boost;


float s = 1.0f;



void move(float a, float b) {
    uv = vec2(a, b) / s;
    gl_Position = MVP*gl_in[0].gl_Position + vec4(a, 4.0f/3.0f*b, 0.0f, 0.0f);
    EmitVertex();
}

void main() {
    s += boost/300.0f;
    gsK = vK[0];
    gsLife = vLife[0];
    move(-s, -s);
    move(s, -s);
    move(-s, s);
    move(s, s);
    EndPrimitive();
 



}    