#version 440 core

in float gsK;
in float gsLife;
in vec2 uv;
out vec4 color;
uniform float boost;
const float lifeTime = 50.0f*0.001f;
const vec3 color_plume1 = vec3(0.5f, 1.0f, 1.0f);
const vec3 color_plume2 = vec3(0.0f, 0.0f, 1.0f);
const vec3 color_boost1 = vec3(1.0f, 0.0f, 1.0f);
const vec3 color_boost2 = vec3(1.0f, 0.0f, 0.0f);


void main()
{
	float k1 = max((1.0f - gsLife / lifeTime), 0.0f);
	float k2 = max(1.0f - length(uv), 0.0f);
	float boost_factor = boost/300.0f;
	vec3 primary_color = mix(color_plume1, color_boost1, boost_factor);
	vec3 secondary_color = mix(color_plume2, color_boost2, boost_factor);
	vec3 c = mix(primary_color, secondary_color, k1*k2);
	
	color = vec4(c,  0.5f*k2*k1);
}




