#version 440 core

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normal;
layout(location = 2) in vec2 uv_coord;
layout(location = 3) in vec3 tangent;
layout(location = 4) in vec3 bitangent;
layout(location = 5) in vec3 barycentric_coord;


uniform mat4 M;
uniform mat4 MVP;

out vec3 vNormal_pass;
out vec3 vPosition_pass;
out vec3 vTangent_pass;
out vec3 vBitangent_pass;
out vec2 TextureUV_pass;
flat out vec3 bcoord_pass;

uniform sampler2D tex0;
uniform sampler2D tex1;




void main()
{
	

	gl_Position = MVP * vec4(position, 1.0);
	vPosition_pass = (M * vec4(position, 1.0)).xyz;
	vNormal_pass = (M * vec4(normalize(normal), 0.0)).xyz;
	vTangent_pass = (M * vec4(normalize(tangent), 0.0f)).xyz;
	vBitangent_pass = (M * vec4(normalize(bitangent), 0.0f)).xyz;
	TextureUV_pass = uv_coord;
	bcoord_pass = barycentric_coord;




}