#version 440 core

layout(triangles) in;
layout(triangle_strip, max_vertices = 3) out;

in vec3 vPosition_pass[];
in vec3 vNormal_pass[];
in float Z_pass[];
in vec2 TextureUV_pass[];
in vec3 vTangent_pass[];
in vec3 vBitangent_pass[];
in vec3 bcoord_pass[];


out vec3 vPosition;
out vec3 vNormal;
out float Z;
out vec2 TextureUV;
out vec3 vTangent;
out vec3 vBitangent;
out vec3 bcoord;
out vec3 H;



void main(void)
{
    int i;

    
    
    vec2 p0 = gl_in[0].gl_Position.xy / gl_in[0].gl_Position.w;
    vec2 p1 = gl_in[1].gl_Position.xy / gl_in[1].gl_Position.w;
    vec2 p2 = gl_in[2].gl_Position.xy / gl_in[2].gl_Position.w;

    float a = length(p1 - p2);
    float b = length(p2 - p0);
    float c = length(p1 - p0);
    float alpha = acos((b * b + c * c - a * a) / (2.0 * b * c));
    float beta = acos((a * a + c * c - b * b) / (2.0 * a * c));
    float ha = abs(c * sin(beta));
    float hb = abs(c * sin(alpha));
    float hc = abs(b * sin(alpha));

    H = vec3(ha, hb, hc);


    for (i = 0; i < gl_in.length(); i++)
    {
        vPosition = vPosition_pass[i];
        vNormal = vNormal_pass[i];
        TextureUV = TextureUV_pass[i];
        vTangent = vTangent_pass[i];
        vBitangent = vBitangent_pass[i];
        bcoord = bcoord_pass[i];
        gl_Position = gl_in[i].gl_Position;
        EmitVertex();

    }
    EndPrimitive();
}

