#version 440 core

out vec4 color;

uniform vec3 cam_pos;
uniform vec3 cam_target;
uniform vec3 cam_up;
uniform vec3 lt_pos;


uniform float time;
layout(location = 0) uniform sampler2D tex0;
layout(location = 1) uniform sampler2D tex1;
uniform int shaderCase;
uniform bool wireframeToggle;
uniform bool mapTangentNormal;

in vec3 vPosition;
in vec3 vNormal;

in vec2 TextureUV;
in vec3 vTangent;
in vec3 vBitangent;
in vec3 bcoord;
in vec3 H;



float Id;
float Is;
float d = 0.6; float s = 0.7f; float alpha = 12.0; float i = 0.25;
float beta = 0.4; float i0;




float min3f(vec3 v) { return min(min(v.x, v.y), v.z); }

void main()
{

		vec3 L = normalize(lt_pos);
		
		vec3 N = normalize(vNormal);
		vec3 T = normalize(vTangent);
		vec3 B = normalize(vBitangent);
		mat3 TBN = mat3(T, B, N);

		if (mapTangentNormal) { N = normalize(vec3(TBN * (2.0f * texture(tex1, TextureUV).rgb - 1.0f))); }
		
		float LN = dot(L, N);

		
		Id = d * max(LN, 0.0);
		
		if (LN < 0.0) { Is = 0; }
		else {
			vec3 V = normalize(cam_pos-vPosition);
			vec3 R = normalize(2 * LN * N - L);
			Is = s * pow(max(dot(R, V), 0.0), alpha);
		}

		color = texture(tex0, TextureUV);
		color = vec4((i + Id) * color.xyz + Is, color.w);


	if (wireframeToggle) {
	float c = 0.002f;
	float d = min3f(H * bcoord);
	float pi = 3.14159265359;
	if (H.x * bcoord.x < c || H.y * bcoord.y < c || H.z * bcoord.z < c) {
		color = vec4(sin(0.5f*pi*d/c)*color.xyz, 1.0f);
	}
	}
	

}




