#version 440 core

in vec2 uv;
out vec4 color;

uniform vec3 cam_pos;
uniform vec3 cam_target;
uniform bool wireframeToggle;
uniform vec3 lt_pos;
uniform mat4 camera_matrix;
uniform mat4 V;
uniform float time;


const float ASPECT = 4.0f / 3.0f;
const float alpha = radians(60.0f);
const float FACTOR = tan(alpha/2.0f);

const vec3 L = normalize(lt_pos);
const vec3 C = normalize(cam_target - cam_pos);
void main()
{
	vec3 uv_prime = vec3(2.0f * uv - 1.0f, 1.0f);
	vec3 ray_direction = normalize(uv_prime*vec3(-ASPECT*FACTOR, FACTOR, 1.0f));
	ray_direction = normalize((camera_matrix*vec4(ray_direction, 0.0f)).xyz);
	vec3 c = vec3(1.0f);




	vec3 R = ray_direction;
	vec3 N = normalize(vec3(0.0f, 1.0f, 0.0f));

	float a = 0.0f;
	float pi = 3.14159265359f;

	float u = 0.3f;
	float r = 0.4f*max(dot(C,L)+u-1.0f,0.0f)/(u);
	float g = 0.25f+pi*(dot(normalize(N - L), normalize(R - L)));
	r *= 1.0f
		+ 0.08f * sin(3.42f * g)
		+ 0.02f * sin(7.46f * g)
		+ 0.01f * sin(16.88f * g)
		+ 0.005f * sin(32.88f * g);
	

	a += (max(max(dot(R,C),0.85f)*dot(R, L), 1.0f-r) + r - 1.0f) / (r);

	
	a = max(a, 0.0f);
	float i;
	for (i = 2.0f; i < 14.0f; i++) {

		float k = i/16.0f;
		float rr = i / 10000.0f;
		rr += sin(30.0f*i) / 2000.0f;
		vec3 H = normalize(k*C+(1.0f-k)*L);
		float a0 = 0.75f*(1.0f-k) * k * dot(C,L)*max(0.0f, dot(H, L)-0.75f)/(1.0f-0.75f);
		float y = dot(H, R);
		if (y > 1.0f-rr) {
			a += 2.0f*(y-(1.0f-rr))/(rr) * (1.0f - a * a) * a0;
		}
	}

	






	color = vec4(c, a);
}