#version 440 core

layout (lines) in;
layout (triangle_strip, max_vertices = 64) out;

out vec3 gsNormal;
out vec3 gsPosition;
out float gsType;

uniform mat4 MVP;
uniform float time;

in float vType[];
const float s = sqrt(200.0f)*10.0f;
const float d = 20.0f;
const float g = 1.0f + (1.0f + sin(5.0f*time))/10.0f;

const vec3 zz = normalize(gl_in[0].gl_Position.xyz - gl_in[1].gl_Position.xyz);
const vec3 xx = normalize(cross(zz,normalize(vec3(zz.x, 0.0f, zz.z))));
const vec3 yy = normalize(cross(zz, xx));

void move(float a, float b, float c) {
    gsPosition = gl_in[0].gl_Position.xyz + g*a * xx + g*b * yy + 0.5f*c * zz;
    gl_Position = MVP * vec4(gsPosition, 1.0f);
    EmitVertex();
}

void main() {

    gsType = vType[0];
    gsNormal = -zz;
    // BACK
    move(-s+d, -s, -d);
    move(-s, -s, -d);
    move(-s+d, s, -d);
    move(-s, s, -d);
    EndPrimitive();
    move(s-d, s, -d);
    move(s, s, -d);
    move(s-d, -s, -d);
    move(s, -s, -d);
    EndPrimitive();
    move(-s+d, -s, -d);
    move(-s+d, -s+d, -d);
    move(s-d, -s, -d);
    move(s-d, -s+d, -d);
    EndPrimitive();
    move(-s+d, s-d, -d);
    move(-s+d, s, -d);
    move(s-d, s-d, -d);
    move(s-d, s, -d);
    EndPrimitive();

    
    // FRONT
    gsNormal = zz;
    move(-s+d, s, d);
    move(-s, s, d);
    move(-s+d, -s, d);
    move(-s, -s, d);
    EndPrimitive();   
    move(s-d, -s, d);
    move(s, -s, d);
    move(s-d, s, d);
    move(s, s, d);
    EndPrimitive();   
    move(s-d, -s, d);
    move(s-d, -s+d, d);
    move(-s+d, -s, d);
    move(-s+d, -s+d, d);
    EndPrimitive();
    move(s-d, s-d, d);
    move(s-d, s, d);
    move(-s+d, s-d, d);
    move(-s+d, s, d);
    EndPrimitive();

    // SIDES
    gsNormal = -xx;
    move(-s, -s, -d);
    move(-s, -s, d);
    move(-s, s, -d);
    move(-s, s, d);
    EndPrimitive();
    move(s-d, -s+d, -d);
    move(s-d, -s+d, d);
    move(s-d, s-d, -d);
    move(s-d, s-d, d);
    EndPrimitive();

    gsNormal = xx;
    move(s, -s, d);
    move(s, -s, -d);
    move(s, s, d);
    move(s, s, -d);
    EndPrimitive();
    move(-s+d, -s+d, d);
    move(-s+d, -s+d, -d);
    move(-s+d, s-d, d);
    move(-s+d, s-d, -d);
    EndPrimitive();

    gsNormal = -yy;
    move(-s, -s, d);
    move(-s, -s, -d);
    move(s, -s, d);
    move(s, -s, -d);
    EndPrimitive();
    move(-s+d, s-d, d);
    move(-s+d, s-d, -d);
    move(s-d, s-d, d);
    move(s-d, s-d, -d);
    EndPrimitive();

    gsNormal = yy;
    move(-s, s, -d);
    move(-s, s, d);
    move(s, s, -d);
    move(s, s, d);
    EndPrimitive();
    move(-s+d, -s+d, -d);
    move(-s+d, -s+d, d);
    move(s-d, -s+d, -d);
    move(s-d, -s+d, d);
    EndPrimitive();

 



}    