#version 440 core

out vec4 color;
in vec3 gsNormal;
in vec3 gsPosition;
in float gsType;
uniform vec3 cam_pos;
uniform vec3 lt_pos;

const float i_diffuse = 0.6f;
const float i_specular = 0.7f;
const float i_ambient = 0.4;
const float alpha = 5.0f;

vec3 light_diffuse = vec3(1.0f, 0.0f, 0.3f);
const vec3 light_specular = vec3(1.0f);
const vec3 light_ambient = vec3(1.0f);
const vec3 V = normalize(cam_pos - gsPosition.xyz);
const vec3 L = normalize(lt_pos);
vec3 light() {


	vec3 N = gsNormal;


	
	float LN = dot(L, N);
	if (gsType == 1.0f) {
		light_diffuse = vec3(0.0f, 0.0f, 1.0f);
	}


	vec3 c = (i_ambient + i_diffuse * max(LN, 0.0f)) * light_diffuse;

	if (LN >= 0.0f) {
		vec3 R = normalize(2 * max(LN,0.0f) * N - L);
		c += i_specular * light_specular * pow(max(dot(R, V), 0.0f),alpha);
	}

	return c;
}

void main()
{
	color = vec4(light(), 1.0f);
}




