#version 430 core

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normal;

out VertexData {
	vec3 position_world;
	vec3 normal_world;
} vert;

uniform mat4 modelMatrix;
uniform mat4 viewProjMatrix;
uniform mat3 normalMatrix;

void main() {
	vert.normal_world = normalMatrix * normal;
	vec4 position_world_ = modelMatrix * vec4(position, 1);
	vert.position_world = position_world_.xyz;
	gl_Position = viewProjMatrix * position_world_;
}