#version 430 core

in vec2 TexCoords;
out vec4 color;

vec3 edgeColor = vec3(0, 0, 0);

float threshold = 0.45;

uniform sampler2D surfaceNormalTexture;
uniform sampler2D depthTexture;

uniform float nearZ;
uniform float farZ;

float linearizeDepth(float depth)
{
   float z = depth * 2.0 - 1.0;
   return (2.0 * nearZ * farZ) / (farZ + nearZ - z * (farZ - nearZ));
}

bool edgeDetectionTexel(vec2 coords) {
    vec3 normal = texture(surfaceNormalTexture, coords).rgb;
    vec3 gradientNormal = fwidth(normal);
	float depth = linearizeDepth(texture(depthTexture, coords).x);
	float gradientDepth = fwidth(depth);

    if (gradientNormal.x + gradientNormal.y + gradientNormal.z + 1.25 * gradientDepth >= threshold) return true;
    return false;
}

float edgeDetection() {
    vec2 texelSize = 1.0 / textureSize(surfaceNormalTexture, 0);

    float edgeOpacity = 0.0;

    for (int i = -1; i <= 1; i++) {
        for (int j = -1; j <= 1; j++) {
            if (edgeDetectionTexel(TexCoords + vec2(i, j) * texelSize)) {
                edgeOpacity += 1.0;
            }
        }
    }
    return min(edgeOpacity/3.0, 1.0);
}

void main()
{
    float edgeOpacity = edgeDetection();
    color = vec4(edgeColor, edgeOpacity);
}
