#version 430 core

out vec4 FragColor;

in vec2 TexCoords;

layout (location = 0) uniform sampler2D scene;
layout (location = 1) uniform sampler2D bloomBlur;
uniform uint bloom;
uniform float exposure;

void main()
{             
    const float gamma = 2.2;
    vec3 hdrColor = texture(scene, TexCoords).rgb;      
    vec3 bloomColor = texture(bloomBlur, TexCoords).rgb;
    if(bloom == 1)
        hdrColor += bloomColor/1.5; // additive blending
    FragColor = vec4(hdrColor, 1.0);
}