#version 440

struct Material
{
	vec3 ambient;
	vec3 diffuse;
	vec3 specular;
	sampler2D diffuseTex;
	sampler2D specularTex;
	float transparency;
};

in vec3 vs_position;
in vec3 vs_color;
in vec2 vs_texcoord;
in vec3 vs_normal;

layout (location = 0) out vec4 finalColor;

// Uniforms
uniform Material material;

void main()
{
	finalColor = texture(material.diffuseTex, vs_texcoord);

	finalColor.rgb = vec3(0.0f, 0.0f, 0.0f);

	if (finalColor.a < 0.1)
	{
		discard;
	}
}