#version 430 core
/*
* Copyright 2019 Vienna University of Technology.
* Institute of Computer Graphics and Algorithms.
* This file is part of the ECG Lab Framework and must not be redistributed.
*/

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normal;
layout(location = 2) in vec2 uv;
layout(location = 3) in mat4 instanceMatrix;

out VertexData {
	vec3 position_world;
	vec3 normal_world;
	vec2 uv;
} vert;

out vec3 colorData;

uniform mat4 modelMatrix;
uniform mat4 viewProjMatrix;
uniform mat3 normalMatrix;
uniform vec3 testColor;
uniform bool windSim = false;
uniform float time;

uniform bool drawingInstanced = false;

void main() {
	vert.normal_world = normalMatrix * normal;
	vert.uv = uv;
	vec4 position_world_ = vec4(1.0f);
	
	if(drawingInstanced){
		position_world_ = instanceMatrix * modelMatrix * vec4(position, 1);
		if(windSim){
			position_world_.y *= sin(time)*((position_world_.x)*0.02)+1;
		}
	}
	else{
		position_world_ = modelMatrix * vec4(position, 1);
	}
	
	vert.position_world = position_world_.xyz;

	gl_Position = viewProjMatrix * position_world_;
	colorData = testColor;
}