#version 430 core
/*
* Copyright 2019 Vienna University of Technology.
* Institute of Computer Graphics and Algorithms.
* This file is part of the ECG Lab Framework and must not be redistributed.
*/


in vec3 Normal;
in vec3 outPosition;

out vec4 color;

uniform samplerCube cubeTexture;
uniform vec3 cameraPos;


void main() {	
	
	vec3 I = normalize(outPosition - cameraPos);
    vec3 R = refract(I, normalize(Normal), 1.0/1.52);
	color = vec4(texture(cubeTexture, R).rgb, 1.0);
	color = mix(vec4(1,0,0,1), color, 0.6);
	
	
}

