#version 430 core
/*
* Copyright 2019 Vienna University of Technology.
* Institute of Computer Graphics and Algorithms.
* This file is part of the ECG Lab Framework and must not be redistributed.
*/

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normal;

out vec3 Normal;
out vec3 outPosition;

uniform mat4 viewProjMatrix;
uniform mat4 modelMatrix;


void main() {
	Normal = mat3(transpose(inverse(modelMatrix))) * normal;
	outPosition = vec3(modelMatrix * vec4(position, 1.0));
	gl_Position = viewProjMatrix * vec4(outPosition, 1.0);
	
}