#version 430 core
/*
* Copyright 2019 Vienna University of Technology.
* Institute of Computer Graphics and Algorithms.
* This file is part of the ECG Lab Framework and must not be redistributed.
*/

layout(location = 0) in vec3 position;

out vec3 TexCoords;

uniform mat4 viewProjMatrix;


void main() {
	TexCoords = position;
	vec4 pos = viewProjMatrix * vec4(position, 1.0);
	gl_Position = pos.xyww;
	
}