#version 430


layout (points) in; 
layout (triangle_strip, max_vertices = 4) out; 

uniform mat4 ProjectionMatrix;

in vData { float TTL1; } vertex[]; 

out vec2 TexCoord0;
flat out float TTL0; 


void main (void) {
	const vec2 size = vec2(5, 5);
	vec4 P = gl_in[0].gl_Position; 
	vec2 va = P.xy + vec2(-0.5, -0.5) * size; 
	gl_Position = ProjectionMatrix * vec4(va, P.zw);
	TexCoord0 = vec2(0.0, 0.0);
	TTL0 = vertex[0].TTL1;
	EmitVertex();

	vec2 vb = P.xy + vec2(-0.5, 0.5) * size; // bottom-left corner
	gl_Position = ProjectionMatrix * vec4(vb, P.zw);
	TexCoord0 = vec2(0.0, 1.0);
	TTL0 = vertex[0].TTL1;
	EmitVertex();

	vec2 vd = P.xy + vec2(0.5, -0.5) * size; // bottom-left corner
	gl_Position = ProjectionMatrix * vec4(vd, P.zw);
	TexCoord0 = vec2(1.0, 0.0);
	TTL0 = vertex[0].TTL1;
	EmitVertex();

		vec2 vc = P.xy + vec2(0.5, 0.5) * size; // bottom-left corner
	gl_Position = ProjectionMatrix * vec4(vc, P.zw);
	TexCoord0 = vec2(1.0, 1.0);
	TTL0 = vertex[0].TTL1;
	EmitVertex();

	EndPrimitive();
}
