#version 430

layout(location = 0) in vec2 screen_coordinate;		// screen space coordinate
uniform mat4 IPV;									// inverse projection view matrix
out vec3 uv_coordinate;								// uv coordinates for texture

void main() {
	vec4 farplane = vec4(screen_coordinate, 0.999999, 1.0);
	vec4 world_view_coordinate = IPV * farplane;
	uv_coordinate = world_view_coordinate.xyz / world_view_coordinate.w;
	gl_Position = farplane;
}
