#version 430

uniform samplerCube sampler; // texture sampler
uniform samplerCube sampler2;
uniform float mix_factor;
in vec3 uv_coordinate;		 // uv coordinate
out vec4 frag_color;		 // fragment color

// mix factor:
// 0.0 -> day
// 1.0 -> night
void main() {
	frag_color = clamp(1.0 - mix_factor, 0.4f, 1.0f) * ((texture(sampler, uv_coordinate) * mix_factor) + (texture(sampler2, uv_coordinate) * (1 - mix_factor)));
}