#version 430

layout(location = 0) in vec3 aPos;
layout(location = 1) in vec3 aNormal;
layout(location = 2) in vec2 aUV;

uniform mat4 ModelMatrix;
uniform mat4 ViewMatrix;
uniform mat4 ProjectionMatrix;
uniform mat4 NormalMatrix;// Normal matrix (M^-1)T

smooth out vec3 camspace_position; // position for per fragment lighting
smooth out vec3 camspace_normal;   // normal for per fragment lighting
smooth out vec2 frag_uv_coordinate;// UV coordinate
smooth out vec3 frag_3D_position;

void main(){
	gl_Position = ProjectionMatrix * ViewMatrix * ModelMatrix * vec4(aPos, 1.0f);

	mat4 MV = ModelMatrix * ViewMatrix;
	mat4 IV = inverse(ViewMatrix);
	vec4 global_position = MV * vec4(aPos, 1.0f);
	global_position = IV * global_position;

	camspace_position = ((ViewMatrix * ModelMatrix) * vec4(aPos.xyz, 1.0f)).xyz;
	camspace_normal = ((ViewMatrix * NormalMatrix) * vec4(aNormal, 0)).xyz;
	frag_uv_coordinate = aUV;
	frag_3D_position = global_position.xyz;
}