#version 430

layout(location = 0) in vec4 inPosLife;    // xyz, lifeRemaining
layout(location = 1) in vec4 inColorInit;  // rgb, initialLife

out VS_OUT {
    vec3 worldPos;
    float lifeRemaining;
    float initLife;
    vec3 color;
} vs_out;

uniform mat4 ModelViewMatrix;
uniform mat4 ProjectionMatrix;

void main() {
    vs_out.worldPos      = inPosLife.xyz;
    vs_out.lifeRemaining = inPosLife.w;
    vs_out.initLife      = inColorInit.w;
    vs_out.color         = inColorInit.rgb;

    gl_Position = ModelViewMatrix * vec4(inPosLife.xyz, 1.0);
}
