#version 430
layout(points) in;
layout(triangle_strip, max_vertices = 4) out;

in VS_OUT {
    vec3 worldPos;
    float lifeRemaining;
    float initLife;
    vec3 color;
} gs_in[];

out GS_OUT {
    vec3 color;
    float alpha;
} gs_out;

uniform mat4 ProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform float ParticleSize;


void main() {
    vec3 p_world = gs_in[0].worldPos;
    float life   = gs_in[0].lifeRemaining;
    float initL  = max(gs_in[0].initLife, 0.0001);
    float t      = clamp(life / initL, 0.0, 1.0);

    //change the opacity (20%)
    float alpha = 0.2;
    float size = ParticleSize * (0.5 + 0.5 * t);

    vec4 p_view = ModelViewMatrix * vec4(p_world, 1.0);

    vec2 offsets[4] = vec2[](
        vec2(-1.0, -1.0),
        vec2( 1.0, -1.0),
        vec2(-1.0,  1.0),
        vec2( 1.0,  1.0)
    );

    for (int i = 0; i < 4; ++i) {
        vec2 o = offsets[i] * size;
        vec4 corner_view = p_view + vec4(o.x, o.y, 0.0, 0.0);

        gl_Position = ProjectionMatrix * corner_view;
        gs_out.color = gs_in[0].color;
        gs_out.alpha = alpha;

        EmitVertex();
    }

    EndPrimitive();
}