#version 430 core

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 normal;
layout(location = 2) in vec2 uv;
layout(location = 3) in vec3 tangent;
layout(location = 4) in vec3 bitangent;

uniform mat4 modelMatrix;
uniform mat4 viewProjMatrix;

out vec2 TexCoords;

void main() 
{
	TexCoords = uv;
	gl_Position = viewProjMatrix * modelMatrix * vec4(position, 1);
}