#version 330 core

layout (location = 0) in vec3 inPos;
layout (location = 1) in vec3 inColor;
layout (location = 2) in vec3 inNormal;
layout (location = 3) in vec2 inTexture;

out vec3 color;
out vec3 Normal;
out vec3 currentPosition;
out vec2 textCoordinates;
out vec4 FragPosLightSpace;

uniform mat4 camMatrix;
uniform mat4 model;
uniform mat4 lightSpaceMatrix;

void main()
{
    currentPosition = vec3(model * vec4(inPos, 1.0f));

    gl_Position = camMatrix * vec4(currentPosition, 1.0f);
    color = inColor;
    Normal = inNormal;
    textCoordinates = inTexture;

    FragPosLightSpace = lightSpaceMatrix * model * vec4(inPos, 1.0f);
}