#version 330 core

layout (location = 0) in vec3 inPos;
layout (location = 3) in vec2 inTexture;

out vec2 textCoordinates;
out float sunHeight;

uniform mat4 model;
uniform mat4 camMatrix;
uniform vec3 sunPosition;

void main()
{
    textCoordinates = inTexture;
    // Pass normalized sun height to fragment shader (-1 to 1 normalized to 0 to 1)
    sunHeight = (sunPosition.y / 150.0);
    gl_Position = camMatrix * model * vec4(inPos, 1.0f);
}