#version 330 core

out vec4 FragColor;
in vec2 textCoordinates;
in float sunHeight;

uniform vec4 lightColor;

void main()
{
    vec2 center = vec2(0.5);
    float dist = length(textCoordinates - center);
    float intensity = 1.0 - smoothstep(0.0, 0.5, dist);
    
    // Calculate atmospheric effect based on sun height
    // When sunHeight is near 0 (horizon): more red/orange
    // When sunHeight is high (1.0): more yellow/white
    float horizonFactor = 1.0 - abs(sunHeight);
    horizonFactor = pow(horizonFactor, 0.5); // Smooth the transition
    
    // Colors for different sun positions
    vec3 sunsetColor = vec3(1.0, 0.3, 0.1);    // Deep orange-red at horizon
    vec3 middayColor = vec3(1.0, 0.95, 0.85);  // Bright white-yellow when high
    vec3 sunriseColor = vec3(1.0, 0.4, 0.2);   // Orange-pink at horizon
    
    // Blend between sunset/sunrise and midday based on height
    vec3 sunColor;
    if (sunHeight > 0.0) {
        // Sun is rising/up - blend from sunrise orange to midday white
        sunColor = mix(middayColor, sunriseColor, horizonFactor);
    } else {
        // Sun is setting/down - blend from midday to sunset
        sunColor = mix(middayColor, sunsetColor, horizonFactor);
    }
    
    // Add extra glow at horizon
    float glowBoost = horizonFactor * 0.3 + 1.0;
    
    FragColor = vec4(sunColor * intensity * glowBoost, intensity);
}