#version 330 core

layout (location = 0) in vec3 inPos;

out float starIntensity;

uniform mat4 camMatrix;
uniform float time;

// Simple hash function for pseudo-random values
float hash(float n) {
    return fract(sin(n) * 43758.5453123);
}

void main()
{
    // Use gl_VertexID for unique per-star seed (better for batched rendering)
    float starSeed = float(gl_VertexID);
    
    // Calculate twinkling based on time and position
    // Each star has its own speed and phase
    float twinkleSpeed = hash(starSeed) * 3.0 + 0.5;  // Varied speeds
    float twinklePhase = hash(starSeed + 100.0) * 6.28318;
    
    // Create more dramatic twinkling effect
    float twinkle1 = sin(time * twinkleSpeed + twinklePhase);
    float twinkle2 = sin(time * twinkleSpeed * 1.5 + twinklePhase + 1.0);
    float twinkle = (twinkle1 * 0.7 + twinkle2 * 0.3) * 0.5 + 0.5;
    
    // Strong intensity variation - stars can get very bright and quite dim
    float baseBrightness = hash(starSeed + 50.0) * 0.4 + 0.8; // Higher base brightness
    starIntensity = baseBrightness * (0.3 + twinkle * 0.7); // More dramatic range
    
    gl_Position = camMatrix * vec4(inPos, 1.0);
    
    // Size also twinkles - stars pulse in size
    float baseSize = 5.0 + hash(starSeed + 200.0) * 5.0; // Even larger base sizes (5-10 pixels)
    float sizeTwinkle = 0.7 + twinkle * 0.6; // Size varies with twinkle
    gl_PointSize = baseSize * sizeTwinkle;
}
