#version 330 core

out vec4 FragColor;
in float starIntensity;

uniform float nightFactor; // 0 = day, 1 = night

void main()
{
    // Make stars round using point coordinates
    vec2 coord = gl_PointCoord - vec2(0.5);
    float dist = length(coord);
    if (dist > 0.5) discard;
    
    // Create bright glowing core with soft falloff
    float coreGlow = 1.0 - smoothstep(0.0, 0.3, dist); // Bright center
    float softEdge = 1.0 - smoothstep(0.3, 0.5, dist); // Soft outer glow
    float glow = coreGlow + softEdge * 0.5;
    
    // Bright white star color (pure white, very bright)
    vec3 starColor = vec3(1.0, 1.0, 1.0);
    
    // Make stars VERY bright and visible
    float brightness = starIntensity * glow * 5.0; // Much higher brightness multiplier
    
    // Smooth fade in/out with night - start appearing earlier
    float nightVisibility = smoothstep(0.0, 0.3, nightFactor); // Appear sooner and fade more gradually
    
    // Final color with high intensity
    vec3 finalColor = starColor * brightness * nightVisibility;
    float alpha = min(1.0, brightness * nightVisibility); // Clamp to prevent over-bright
    
    FragColor = vec4(finalColor, alpha);
}
